// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------  
   float2 ViewSize;
   float Offset=14.0;
   float2 Aspect={1.0,1.0};

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
	Texture=<RenderTexture>;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
	float2 Tex:TEXCOORD0;
	float4 Tex1:TEXCOORD1;
	float4 Tex2:TEXCOORD2;
	float4 Tex3:TEXCOORD3;
	float4 Tex4:TEXCOORD4;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos; 
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
 	OUT.Tex1.xy=OUT.Tex+float2(ViewSize.x,ViewSize.y)*Offset*Aspect;
 	OUT.Tex1.zw=OUT.Tex+float2(0.0,ViewSize.y)*Offset*Aspect*1.2;
 	OUT.Tex2.xy=OUT.Tex+float2(-ViewSize.x,ViewSize.y)*Offset*Aspect;
 	OUT.Tex2.zw=OUT.Tex+float2(ViewSize.x,0.0)*Offset*Aspect*1.2;
 	OUT.Tex3.xy=OUT.Tex+float2(-ViewSize.x,0.0)*Offset*Aspect*1.2;
 	OUT.Tex3.zw=OUT.Tex+float2(ViewSize.x,-ViewSize.y)*Offset*Aspect;
 	OUT.Tex4.xy=OUT.Tex+float2(0.0,-ViewSize.y)*Offset*Aspect*1.2;
 	OUT.Tex4.zw=OUT.Tex+float2(-ViewSize.x,-ViewSize.y)*Offset*Aspect;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float3 FrameRender=tex2D(RenderSampler,IN.Tex).xyz*0.25
	                  +tex2D(RenderSampler,IN.Tex1.xy).xyz*0.0625
			  +tex2D(RenderSampler,IN.Tex1.zw).xyz*0.125
		          +tex2D(RenderSampler,IN.Tex2.xy).xyz*0.0625
			  +tex2D(RenderSampler,IN.Tex2.zw).xyz*0.125
			  +tex2D(RenderSampler,IN.Tex3.xy).xyz*0.125
		          +tex2D(RenderSampler,IN.Tex3.zw).xyz*0.0625
			  +tex2D(RenderSampler,IN.Tex4.xy).xyz*0.125
			  +tex2D(RenderSampler,IN.Tex4.zw).xyz*0.0625;
	return float4(FrameRender,1.0);
     }

//--------------
// techniques   
//--------------
    technique Bloom
      {
 	pass p1
      {	
 	VertexShader = compile vs_3_0 VS();
 	PixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
